Player.initialise = Utils.appendedFunction(Player.initialise, function(self, connection, isOwner)
    if self.targeter == nil then return end
    -- sneak into the player targeter. it's important to return always true, or else the complete targeter could break!
    self.targeter:addFilterToTargetType(PlayerInputComponent, function(hitNode)
        if hitNode ~= nil and CollisionFlag.getHasGroupFlagSet(hitNode, CollisionFlag.VEHICLE) then
            local targetedVehicle = g_currentMission:getNodeObject(hitNode)
            if targetedVehicle ~= nil then
                targetedVehicle = targetedVehicle.rootVehicle or targetedVehicle
                if targetedVehicle.spec_enterable ~= nil and targetedVehicle:getIsEnterable() then
                    targetedVehicle.interactionFlag = Vehicle.INTERACTION_FLAG_ENTERABLE
                    g_currentMission.interactiveVehicleInRange = targetedVehicle
                end
            end
        end
        return true
    end)
end)