--[[
    InputBindingExtension

    Useful methods extending the InputBinding class

	@author: 		BayernGamers
	@date: 			01.06.2025
	@version:		1.0

	History:		v1.0 @01.06.2025 - initial implementation in FS25
                    ------------------------------------------------------------------------------------------------------

	
	License:        Terms:
                        Usage:
                            Feel free to use this work as-is as long as you adhere to the following terms:
						Attribution:
							You must give appropriate credit to the original author when using this work.
						No Derivatives:
							You may not alter, transform, or build upon this work in any way.
						Usage:
							The work may be used for personal and commercial purposes, provided it is not modified or adapted.
						Additional Clause:
							This script may not be converted, adapted, or incorporated into any other game versions or platforms except by GIANTS Software.
]]

InputBindingExtension = {}

function InputBindingExtension.getActionEventActive(inputBinding, actionEventId)
    local actionEvent = inputBinding.events[actionEventId]
    if actionEvent then
        return actionEvent.isActive
    end
    return false
end

g_inputBinding.getActionEventActive = InputBindingExtension.getActionEventActive