--[[
    AttachableLightsExtension

    Reworks the attachable's behavior to be aware of attach implements manually.

	@author: 		BayernGamers
	@date: 			09.06.2025
	@version:		1.0

	History:		v1.0 @09.06.2025 - initial implementation in FS25
                    ------------------------------------------------------------------------------------------------------

	
	License:        Terms:
                        Usage:
                            Feel free to use this work as-is as long as you adhere to the following terms:
						Attribution:
							You must give appropriate credit to the original author when using this work.
						No Derivatives:
							You may not alter, transform, or build upon this work in any way.
						Usage:
							The work may be used for personal and commercial purposes, provided it is not modified or adapted.
						Additional Clause:
							This script may not be converted, adapted, or incorporated into any other game versions or platforms except by GIANTS Software.
]]
source(Utils.getFilename("scripts/utils/LoggingUtil.lua", g_currentModDirectory))

local log = LoggingUtil.new(true, LoggingUtil.DEBUG_LEVELS.HIGH, "AttachableLightsExtension.lua")

AttachableLightsExtension = {}
AttachableLightsExtension.MOD_DIRECTORY = g_currentModDirectory
AttachableLightsExtension.MOD_NAME = g_currentModName           

function AttachableLightsExtension.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations) and SpecializationUtil.hasSpecialization(Lights, specializations)
end

function AttachableLightsExtension.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onPreLoad", AttachableLightsExtension)
    SpecializationUtil.registerEventListener(vehicleType, "onLoad", AttachableLightsExtension)
    SpecializationUtil.registerEventListener(vehicleType, "onPostLoad", AttachableLightsExtension)
end

function AttachableLightsExtension.registerOverwrittenFunctions(vehicleType)
    SpecializationUtil.registerOverwrittenFunction(vehicleType, "setNextLightsState", AttachableLightsExtension.setNextLightsState)
    SpecializationUtil.registerOverwrittenFunction(vehicleType, "setLightsTypesMask", AttachableLightsExtension.setLightsTypesMask)
    SpecializationUtil.registerOverwrittenFunction(vehicleType, "setTopLightsVisibility", AttachableLightsExtension.setTopLightsVisibility)
    SpecializationUtil.registerOverwrittenFunction(vehicleType, "setBrakeLightsVisibility", AttachableLightsExtension.setBrakeLightsVisibility)
    SpecializationUtil.registerOverwrittenFunction(vehicleType, "setReverseLightsVisibility", AttachableLightsExtension.setReverseLightsVisibility)
    SpecializationUtil.registerOverwrittenFunction(vehicleType, "setInteriorLightsVisibility", AttachableLightsExtension.setInteriorLightsVisibility)
    SpecializationUtil.registerOverwrittenFunction(vehicleType, "setTurnLightState", AttachableLightsExtension.setTurnLightState)
    SpecializationUtil.registerOverwrittenFunction(vehicleType, "setBeaconLightsVisibility", AttachableLightsExtension.setBeaconLightsVisibility)
end

function AttachableLightsExtension:onPreLoad(savegame)
    self.spec_attachableLightsExtension = {}
end

function AttachableLightsExtension:onLoad(savegame)
    local spec = self.spec_attachableLightsExtension

    spec.hasConnectionHoses = false
    spec.modSettingsManager = AttachImplementsManuallySettingsManager.getInstance()
end

function AttachableLightsExtension:onPostLoad(savegame)
    local spec = self.spec_attachableLightsExtension
    local spec_connectionHoses = self.spec_connectionHoses

    spec.hasConnectionHoses = #spec_connectionHoses.toolConnectorHoses > 0 or #spec_connectionHoses.hoseNodes > 0 or #spec_connectionHoses.customHoseTargets > 0 or #spec_connectionHoses.customHoses > 0 or #spec_connectionHoses.hoseSkipNodes > 0
end

function AttachableLightsExtension:setNextLightsState(superFunc, increment)
    local spec = self.spec_attachableLightsExtension

    if spec.hasConnectionHoses then
        local attacherVehicle = self:getAttacherVehicle()
        
        if attacherVehicle ~= nil and attacherVehicle.spec_attachImplementsManually ~= nil and attacherVehicle.getIsElectricConnected then
            if not attacherVehicle:getIsElectricConnected(self) then
                return
            end
        end
    end

    superFunc(self, increment)
end

function AttachableLightsExtension:setLightsTypesMask(superFunc, lightsTypesMask, force, noEventSend)
    local spec = self.spec_attachableLightsExtension

    if spec.hasConnectionHoses then
        local attacherVehicle = self:getAttacherVehicle()
        
        if attacherVehicle ~= nil and attacherVehicle.spec_attachImplementsManually ~= nil and attacherVehicle.getIsElectricConnected then
            if not attacherVehicle:getIsElectricConnected(self) then
                superFunc(self, 0, force, noEventSend)
                return
            end
        end
    end

    superFunc(self, lightsTypesMask, force, noEventSend)
end

function AttachableLightsExtension:setTopLightsVisibility(superFunc, visibility)
    local spec = self.spec_attachableLightsExtension

    if spec.hasConnectionHoses then
        local attacherVehicle = self:getAttacherVehicle()
        
        if attacherVehicle ~= nil and attacherVehicle.spec_attachImplementsManually ~= nil and attacherVehicle.getIsElectricConnected then
            if not attacherVehicle:getIsElectricConnected(self) then
                superFunc(self, false)
                return
            end
        end
    end

    superFunc(self, visibility)
end

function AttachableLightsExtension:setBrakeLightsVisibility(superFunc, visibility)
    local spec = self.spec_attachableLightsExtension

    if spec.hasConnectionHoses then
        local attacherVehicle = self:getAttacherVehicle()
        
        if attacherVehicle ~= nil and attacherVehicle.spec_attachImplementsManually ~= nil and attacherVehicle.getIsElectricConnected then
            if not attacherVehicle:getIsElectricConnected(self) then
                superFunc(self, false)
                return
            end
        end
    end

    superFunc(self, visibility)
end

function AttachableLightsExtension:setReverseLightsVisibility(superFunc, visibility)
    local spec = self.spec_attachableLightsExtension

    if spec.hasConnectionHoses then
        local attacherVehicle = self:getAttacherVehicle()
        
        if attacherVehicle ~= nil and attacherVehicle.spec_attachImplementsManually ~= nil and attacherVehicle.getIsElectricConnected then
            if not attacherVehicle:getIsElectricConnected(self) then
                superFunc(self, false)
                return
            end
        end
    end

    superFunc(self, visibility)
end

function AttachableLightsExtension:setInteriorLightsVisibility(superFunc, visibility)
    local spec = self.spec_attachableLightsExtension

    if spec.hasConnectionHoses then
        local attacherVehicle = self:getAttacherVehicle()
        
        if attacherVehicle ~= nil and attacherVehicle.spec_attachImplementsManually ~= nil and attacherVehicle.getIsElectricConnected then
            if not attacherVehicle:getIsElectricConnected(self) then
                superFunc(self, false)
                return
            end
        end
    end

    superFunc(self, visibility)
end

function AttachableLightsExtension:setTurnLightState(superFunc, state, force, noEventSend)
    local spec = self.spec_attachableLightsExtension

    if spec.hasConnectionHoses then
        local attacherVehicle = self:getAttacherVehicle()
        
        if attacherVehicle ~= nil and attacherVehicle.spec_attachImplementsManually ~= nil and attacherVehicle.getIsElectricConnected then
            if not attacherVehicle:getIsElectricConnected(self) then
                superFunc(self, false, force, noEventSend)
                return
            end
        end
    end

    superFunc(self, state, force, noEventSend)
end

function AttachableLightsExtension:setBeaconLightsVisibility(superFunc, visibility, force, noEventSend)
    local spec = self.spec_attachableLightsExtension

    if spec.hasConnectionHoses then
        local attacherVehicle = self:getAttacherVehicle()
        
        if attacherVehicle ~= nil and attacherVehicle.spec_attachImplementsManually ~= nil and attacherVehicle.getIsElectricConnected then
            if not attacherVehicle:getIsElectricConnected(self) then
                superFunc(self, false, force, noEventSend)
                return
            end
        end
    end

    superFunc(self, visibility, force, noEventSend)
end